// Wrapper.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "mmsystem.h"
#include <d3dx9.h>

#define EXPORT extern "C" __declspec(dllexport)

LPDIRECT3D9             D3D       = NULL; 
LPDIRECT3DDEVICE9       D3dDevice = NULL; 
LPD3DXMESH              Teapot    = NULL; 

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

EXPORT long __stdcall DX_InitD3D( HWND hWnd )
{
    if( NULL == ( D3D = Direct3DCreate9( D3D_SDK_VERSION ) ) )
        return E_FAIL;

    D3DPRESENT_PARAMETERS d3dpp; 
    ZeroMemory( &d3dpp, sizeof(d3dpp) );
    d3dpp.Windowed = TRUE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
    d3dpp.BackBufferFormat = D3DFMT_UNKNOWN;
    d3dpp.EnableAutoDepthStencil = TRUE;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
	d3dpp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

    if( FAILED( D3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd,
                                      D3DCREATE_HARDWARE_VERTEXPROCESSING,
                                      &d3dpp, &D3dDevice ) ) )
    {
		if( FAILED( D3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd,
                                      D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                                      &d3dpp, &D3dDevice ) ) )
			{
				return E_FAIL;
			}
    }

	// Enable the Zbuffer
    D3dDevice->SetRenderState( D3DRS_ZENABLE, TRUE );

	// Create the teapot mesh
	D3DXCreateTeapot(D3dDevice,&Teapot,NULL);

	// Create a material for the teapot
	D3DMATERIAL9 mtrl;
	ZeroMemory( &mtrl, sizeof(mtrl) );
	mtrl.Diffuse.r = mtrl.Ambient.r = 1.0f;
	mtrl.Diffuse.g = mtrl.Ambient.g = 0.0f;
	mtrl.Diffuse.b = mtrl.Ambient.b = 0.0f;
	mtrl.Diffuse.a = mtrl.Ambient.a = 1.0f;
	D3dDevice->SetMaterial( &mtrl );

	// Set up a directional light
	D3DXVECTOR3 vecDir;
	D3DLIGHT9   light;
	ZeroMemory( &light, sizeof(light) );
	light.Type = D3DLIGHT_DIRECTIONAL;
	light.Diffuse.r = 1.0f;
	light.Diffuse.g = 1.0f;
	light.Diffuse.b = 1.0f;

	vecDir = D3DXVECTOR3(-1.0f,-1.0f,1.0f);
	D3DXVec3Normalize( (D3DXVECTOR3*)&light.Direction, &vecDir );

	light.Range = 1000.0f;

	D3dDevice->SetLight( 0, &light );
	D3dDevice->LightEnable( 0, TRUE);
	D3dDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	D3dDevice->SetRenderState( D3DRS_AMBIENT, 0x00202020 );


    return S_OK;
}

EXPORT VOID __stdcall DX_Cleanup()
{
    if( Teapot != NULL )
        Teapot->Release();

    if( D3dDevice != NULL) 
        D3dDevice->Release();

    if( D3D != NULL)
        D3D->Release();
}

VOID SetupMatrices()
{
    D3DXMATRIXA16 matWorld;
    D3DXMatrixRotationY( &matWorld, timeGetTime()/1000.0f );
    D3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

    D3DXVECTOR3 vEyePt( 0.0f, 3.0f,-5.0f );
    D3DXVECTOR3 vLookatPt( 0.0f, 0.0f, 0.0f );
    D3DXVECTOR3 vUpVec( 0.0f, 1.0f, 0.0f );
    D3DXMATRIXA16 matView;
    D3DXMatrixLookAtLH( &matView, &vEyePt, &vLookatPt, &vUpVec );
    D3dDevice->SetTransform( D3DTS_VIEW, &matView );

    D3DXMATRIXA16 matProj;
    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 1.33f, 1.0f, 1000.0f );
    D3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}


EXPORT VOID __stdcall DX_Render()
{
    if( NULL == D3dDevice )
        return;

    // Clear the backbuffer to a blue color and empty the Zbuffer
	D3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 
                         D3DCOLOR_XRGB(0,0,255), 1.0f, 0 );
    
    if( SUCCEEDED( D3dDevice->BeginScene() ) )
    {
		SetupMatrices();

        Teapot->DrawSubset(0);
        
		D3dDevice->EndScene();
    }

    // Flip the backbuffer 
    D3dDevice->Present( NULL, NULL, NULL, NULL );
}

EXPORT VOID __stdcall DX_Wireframe(int Enable)
{
 if (Enable==TRUE)
	 	D3dDevice->SetRenderState( D3DRS_FILLMODE, D3DFILL_WIREFRAME);
 else
	 	D3dDevice->SetRenderState( D3DRS_FILLMODE, D3DFILL_SOLID);
}
